package net.w_horse.excelpojo.converter;

import java.text.SimpleDateFormat;
import java.util.Date;

import net.w_horse.excelpojo.ExcelPOJOException;

/**
 * ZƃtB[hɑ΂tϊNX<br>
 * Dat^AƕitH[}bgϊjɑ΂鑊ݕϊs<br>
 * Ⴆ΃tH[}bgFyyyy/MM/dd̕ƃtH[}bgFyyyy-MM-dd̑ݕϊsB<br>
 * Ԃł͕ tH[}bgFyyyy/MM/dd 
 *  tH[}bgFyyyyMMdd ̑ݕϊsB<br>
 *
 *
 * @author kawahara
 *
 */
public class StringDateConverter implements CellFieldConverter {
	private String cellType = String.class.getName();
	private String cellFormat = "yyyy/M/d";
	private String fieldType = String.class.getName();
	private String fieldFormat = "yyyyMMdd";

	public StringDateConverter() {
	}

	@Override
	public Object convertField2Cell(Object value) throws ExcelPOJOException {
		return convert(value, fieldType, fieldFormat, cellType, cellFormat);
	}

	@Override
	public Object convertCell2Field(Object value) throws ExcelPOJOException {
		return convert(value, cellType, cellFormat, fieldType, fieldFormat);
	}

	private Object convert(Object value, String fromType, String fromFormat,
				String toType, String toFormat) throws ExcelPOJOException{
		try {
			// DateString̕ϊ
			if (fromType.equals(Date.class.getName())
				&& (toType.equals(String.class.getName()))
			) {
				return (new SimpleDateFormat(toFormat)).format(value);
			}

			// StringString̕ϊ
			if (fromType.equals(String.class.getName())
				&& (toType.equals(String.class.getName()))
			) {
				Date theDate = (new SimpleDateFormat(fromFormat)).parse((String) value);
				return (new SimpleDateFormat(toFormat)).format(theDate);
			}

			// StringDate̕ϊ
			if (fromType.equals(String.class.getName())
				&& (toType.equals(Date.class.getName()))
			) {
				Date theDate = (new SimpleDateFormat(fromFormat)).parse((String) value);
				return theDate;
			}

			// ȊO͗O
			String msg = String.format("An illegal type is specified between [%s] and [%s].\n"
					+ "Only between String and Date can be specified for a conversion type.",
					cellType, fieldType);
			throw new IllegalArgumentException(msg);
		} catch (Exception e) {
			throw new ExcelPOJOException(e);
		}

	}

	public void setCellType(String cellType) {
		this.cellType = cellType;
	}
	public void setCellFormat(String cellFormat) {
		this.cellFormat = cellFormat;
	}
	public void setFieldType(String fieldType) {
		this.fieldType = fieldType;
	}
	public void setFieldFormat(String fieldFormat) {
		this.fieldFormat = fieldFormat;
	}

}
